<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

// Check if user is logged in
requireLogin();

$pageTitle = 'داشبورد';
$userId = $_SESSION['user_id'];

// Get user orders directly from database
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC LIMIT 50");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$orders = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

/* Keep Font Awesome for icons */
.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

/* صفحه با فاصله از بالا برای navbar */
body {
    background: #f5f5f5 !important;
    padding-top: 80px;
}

.dashboard-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

.dashboard-header {
    background: white;
    border-radius: 12px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.dashboard-header h1 {
    color: #CB1919;
    margin-bottom: 10px;
    font-weight: 700;
}

.dashboard-header p {
    color: #666;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: white;
    border-radius: 10px;
    padding: 25px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.stat-icon {
    font-size: 40px;
    margin-bottom: 15px;
}

.stat-icon.primary {
    color: #CB1919;
}

.stat-icon.success {
    color: #28a745;
}

.stat-icon.warning {
    color: #ffc107;
}

.stat-value {
    font-size: 32px;
    font-weight: bold;
    color: #333;
    margin-bottom: 5px;
}

.stat-label {
    color: #999;
    font-size: 14px;
}

.orders-section {
    background: white;
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.orders-section h2 {
    color: #667eea;
    margin-bottom: 25px;
}

.orders-table {
    width: 100%;
    border-collapse: collapse;
}

.orders-table thead {
    background: #f8f9fa;
}

.orders-table th {
    padding: 15px;
    text-align: right;
    font-weight: 600;
    color: #666;
    border-bottom: 2px solid #e0e0e0;
}

.orders-table td {
    padding: 15px;
    text-align: right;
    border-bottom: 1px solid #f0f0f0;
}

.status-badge {
    display: inline-block;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
}

.status-badge.pending {
    background: #fff3cd;
    color: #856404;
}

.status-badge.paid {
    background: #d4edda;
    color: #155724;
}

.status-badge.failed {
    background: #f8d7da;
    color: #721c24;
}

.status-badge.cancelled {
    background: #e2e3e5;
    color: #383d41;
}

.btn-view {
    display: inline-block;
    padding: 6px 15px;
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
    text-decoration: none;
    border-radius: 5px;
    font-size: 13px;
    transition: all 0.3s ease;
}

.btn-view:hover {
    background: linear-gradient(135deg, #FF2929 0%, #FF4444 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(203, 25, 25, 0.3);
}

.no-orders {
    text-align: center;
    padding: 50px;
    color: #999;
}

.no-orders i {
    font-size: 60px;
    margin-bottom: 20px;
    color: #ddd;
}

/* Hide mobile cards on desktop */
.d-md-none {
    display: none;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .dashboard-container {
        padding: 10px;
    }
    
    .dashboard-header {
        padding: 20px;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .orders-section {
        padding: 15px;
        overflow-x: auto;
    }
    
    .table-responsive {
        display: none !important;
    }
    
    .d-md-none {
        display: block !important;
    }
    
    .order-card {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border: 1px solid #e0e0e0;
    }
    
    .order-card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
        padding-bottom: 10px;
        border-bottom: 1px solid #e0e0e0;
    }
    
    .order-card-id {
        font-weight: bold;
        color: #667eea;
    }
    
    .order-card-body {
        margin-bottom: 10px;
    }
    
    .order-card-row {
        display: flex;
        justify-content: space-between;
        padding: 5px 0;
        font-size: 14px;
    }
    
    .order-card-label {
        color: #666;
        font-weight: 600;
    }
    
    .order-card-value {
        color: #333;
        font-weight: bold;
    }
}
</style>

<div class="container">
    <div class="dashboard-container">
        <div class="dashboard-header">
            <h1><i class="fas fa-user-circle"></i> داشبورد کاربری</h1>
            <p>خوش آمدید، <?php echo htmlspecialchars($_SESSION['mobile']); ?></p>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon primary">
                    <i class="fas fa-shopping-bag"></i>
                </div>
                <div class="stat-value"><?php echo count($orders); ?></div>
                <div class="stat-label">کل سفارشات</div>
            </div>

            <div class="stat-card">
                <div class="stat-icon success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-value">
                    <?php 
                    $paidOrders = array_filter($orders, function($o) { return $o['status'] === 'paid'; });
                    echo count($paidOrders);
                    ?>
                </div>
                <div class="stat-label">سفارشات موفق</div>
            </div>

            <div class="stat-card">
                <div class="stat-icon warning">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-value">
                    <?php 
                    $pendingOrders = array_filter($orders, function($o) { return $o['status'] === 'pending'; });
                    echo count($pendingOrders);
                    ?>
                </div>
                <div class="stat-label">در انتظار پرداخت</div>
            </div>
        </div>

        <div class="orders-section">
            <h2><i class="fas fa-list"></i> سفارشات من</h2>

            <?php if (empty($orders)): ?>
                <div class="no-orders">
                    <i class="fas fa-shopping-cart"></i>
                    <h3>هنوز سفارشی ثبت نکرده‌اید</h3>
                    <p>برای خرید eSIM به <a href="/" style="color: #667eea;">صفحه اصلی</a> بروید</p>
                </div>
            <?php else: ?>
                <!-- Desktop Table -->
                <div class="table-responsive" style="overflow-x: auto; display: block;">
                    <table class="orders-table" style="width: 100%; display: table;">
                        <thead>
                            <tr>
                                <th>شماره</th>
                                <th>بسته</th>
                                <th>کشور</th>
                                <th>حجم</th>
                                <th>مدت</th>
                                <th>مبلغ</th>
                                <th>وضعیت</th>
                                <th>تاریخ</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orders as $order): ?>
                                <tr>
                                    <td>#<?php echo $order['id']; ?></td>
                                    <td><?php echo htmlspecialchars($order['package_name']); ?></td>
                                    <td><?php echo htmlspecialchars($order['country_name']); ?></td>
                                    <td><?php echo htmlspecialchars($order['data_amount']); ?></td>
                                    <td><?php echo $order['validity_days']; ?> روز</td>
                                    <td><?php echo formatPrice($order['price_irr']); ?> تومان</td>
                                    <td>
                                        <?php
                                        $statusLabels = [
                                            'pending' => 'در انتظار',
                                            'paid' => 'پرداخت شده',
                                            'failed' => 'ناموفق',
                                            'cancelled' => 'لغو شده'
                                        ];
                                        $statusLabel = $statusLabels[$order['status']] ?? $order['status'];
                                        ?>
                                        <span class="status-badge <?php echo $order['status']; ?>">
                                            <?php echo $statusLabel; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('Y/m/d', strtotime($order['created_at'])); ?></td>
                                    <td>
                                        <a href="/order-view.php?id=<?php echo $order['id']; ?>" class="btn-view">
                                            <i class="fas fa-eye"></i> مشاهده
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Mobile Cards -->
                <div class="d-md-none">
                    <?php foreach ($orders as $order): ?>
                        <div class="order-card">
                            <div class="order-card-header">
                                <span class="order-card-id">#<?php echo $order['id']; ?></span>
                                <?php
                                $statusLabels = [
                                    'pending' => 'در انتظار',
                                    'paid' => 'پرداخت شده',
                                    'failed' => 'ناموفق',
                                    'cancelled' => 'لغو شده'
                                ];
                                $statusLabel = $statusLabels[$order['status']] ?? $order['status'];
                                ?>
                                <span class="status-badge <?php echo $order['status']; ?>">
                                    <?php echo $statusLabel; ?>
                                </span>
                            </div>
                            <div class="order-card-body">
                                <div class="order-card-row">
                                    <span class="order-card-label">بسته:</span>
                                    <span class="order-card-value"><?php echo htmlspecialchars($order['package_name']); ?></span>
                                </div>
                                <div class="order-card-row">
                                    <span class="order-card-label">کشور:</span>
                                    <span class="order-card-value"><?php echo htmlspecialchars($order['country_name']); ?></span>
                                </div>
                                <div class="order-card-row">
                                    <span class="order-card-label">حجم:</span>
                                    <span class="order-card-value"><?php echo htmlspecialchars($order['data_amount']); ?></span>
                                </div>
                                <div class="order-card-row">
                                    <span class="order-card-label">مدت:</span>
                                    <span class="order-card-value"><?php echo $order['validity_days']; ?> روز</span>
                                </div>
                                <div class="order-card-row">
                                    <span class="order-card-label">مبلغ:</span>
                                    <span class="order-card-value"><?php echo formatPrice($order['price_irr']); ?> تومان</span>
                                </div>
                                <div class="order-card-row">
                                    <span class="order-card-label">تاریخ:</span>
                                    <span class="order-card-value"><?php echo date('Y/m/d', strtotime($order['created_at'])); ?></span>
                                </div>
                            </div>
                            <a href="/order-view.php?id=<?php echo $order['id']; ?>" class="btn-view" style="display: block; text-align: center;">
                                <i class="fas fa-eye"></i> مشاهده جزئیات
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
